IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_RespondentConnectQuotasIdList]') AND type in (N'P', N'PC'))
    DROP PROCEDURE [dbo].[sp_RespondentConnectQuotasIdList]
GO

CREATE PROCEDURE [dbo].[sp_RespondentConnectQuotasIdList]
    @ProjectId  INT,
    @completedSynchedIds AS [dbo].[RespondentsIdList] READONLY,
    @Action     INT
AS
IF ( @Action = 3 )
BEGIN
    -- Reset QTOnline
    UPDATE Quota SET QtOnline = 0;
END 
ELSE 
BEGIN
	DECLARE @Modifier INT;
    IF ( @Action = 1 ) SET @Modifier = 1;
    ELSE If ( @Action = 2 ) SET @Modifier = -1;

	DECLARE @quotaIdList TABLE(QuotaId int, IncrementValue int);
    INSERT INTO @quotaIdList 
	SELECT StrQuotaId, SUM((ISNULL(IncrementValue, 1) * @Modifier)) AS IncrementValue
    FROM Stratum s
    INNER JOIN @completedSynchedIds si ON si.Id = StrRespondent
	GROUP BY StrQuotaId

    -- VX_TR_Stratum does not allow QtOnLine to be less than 0
	UPDATE q
    SET q.QtOnLine = CASE WHEN QtOnLine + IncrementValue < 0 THEN 0 ELSE QtOnLine + IncrementValue END
    FROM Quota q 
    INNER JOIN @quotaIdList qid ON q.QtQuotaId = qid.QuotaId
    WHERE q.QtStratum > 0
END
GO

